/*
 * Decompiled with CFR 0.152.
 */
package com.chronapp.porter;

import com.chronapp.porter.client.connection.PorterAPIClient;
import com.chronapp.porter.client.connection.RestApiDownloader;
import com.chronapp.porter.common.ChronappException;
import com.chronapp.porter.common.ChronappExceptionStore;
import com.chronapp.porter.config.ApiTablePair;
import com.chronapp.porter.config.ApiVariantPair;
import com.chronapp.porter.config.ClientConfig;
import com.chronapp.porter.config.DownloadApiTable;
import com.chronapp.porter.download.DbDownloader;
import com.chronapp.porter.upload.DataFetcher;
import com.chronapp.porter.upload.RestApiUploader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.jboss.logging.Logger;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;

public class ChronappInterfaceClient {
    private static final Logger LOGGER = Logger.getLogger(ChronappInterfaceClient.class);
    private static PorterAPIClient client;
    private static LinkedList<ChronappExceptionStore> exceptionStoreList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int systemExitCode = 0;
        exceptionStoreList = ChronappInterfaceClient.readExceptionsFromSystemFile();
        if (args.length != 1) {
            LOGGER.error("Please provide a filepath to a config.yaml file");
            System.exit(1);
        }
        String filepath = args[0];
        try {
            UUID clientCallId = UUID.randomUUID();
            ClientConfig config = ChronappInterfaceClient.readConfig(filepath, clientCallId);
            client = new PorterAPIClient(config);
            ChronappInterfaceClient.porterStart(config, clientCallId);
            ChronappInterfaceClient.handleUploads(config, clientCallId);
            ChronappInterfaceClient.handleImport(config, clientCallId);
            ChronappInterfaceClient.handleExport(config, clientCallId);
            ChronappInterfaceClient.handleDownloads(config, clientCallId);
            ChronappInterfaceClient.porterEnd(config, clientCallId);
        }
        catch (ChronappException e) {
            LOGGER.error(e);
            ChronappInterfaceClient.addExceptionToStore(e);
            systemExitCode = 1;
        }
        finally {
            List<UUID> successfullyLoggedExceptions = ChronappInterfaceClient.handleExceptions();
            successfullyLoggedExceptions.forEach(uuid -> exceptionStoreList.removeIf(exStore -> exStore.getJobUuid().equals(uuid)));
            exceptionStoreList.removeIf(ChronappExceptionStore::isExpired);
            ChronappInterfaceClient.writeExceptionToSystemFile();
            System.exit(systemExitCode);
        }
    }

    private static ClientConfig readConfig(String filepath, UUID clientCallId) {
        try {
            FileInputStream inputStream = new FileInputStream(filepath);
            return (ClientConfig)new Yaml(new Constructor(ClientConfig.class, new LoaderOptions())).load(inputStream);
        }
        catch (FileNotFoundException e) {
            throw new ChronappException("yaml-config file not found", e, clientCallId, "loading config", null);
        }
    }

    private static void porterStart(ClientConfig config, UUID clientCallId) {
        LOGGER.info("Starting porter with description: " + config.getDescription());
        client.begin(clientCallId, config.getDescription());
    }

    private static void porterEnd(ClientConfig config, UUID clientCallId) {
        client.end(clientCallId, config.getDescription());
        LOGGER.info("porter successfully finished");
    }

    private static void handleUploads(ClientConfig config, UUID clientCallId) {
        if (!config.getUploads().isEmpty()) {
            LOGGER.info("Starting upload");
        }
        for (ApiTablePair uploadConfig : config.getUploads()) {
            if (uploadConfig.isTruncate()) {
                LOGGER.info("truncating " + uploadConfig.getApi());
                client.truncate(uploadConfig.getApi(), clientCallId, config.getDescription());
            }
            LOGGER.info("uploading from " + uploadConfig.getTable() + " to " + uploadConfig.getApi());
            RestApiUploader uploader = new RestApiUploader(client, uploadConfig.getApi());
            new DataFetcher(config, uploader, uploadConfig.getTable(), clientCallId);
        }
        if (!config.getUploads().isEmpty()) {
            LOGGER.info("Upload finished");
        }
    }

    private static void handleImport(ClientConfig config, UUID clientCallId) {
        if (!config.getImp().isEmpty()) {
            LOGGER.info("Handling import data");
        }
        for (ApiVariantPair impConfig : config.getImp()) {
            LOGGER.info("import variant " + impConfig.getVariant() + " to " + impConfig.getApi());
            client.updateImport(impConfig.getApi(), clientCallId, impConfig.getVariant());
        }
        if (!config.getImp().isEmpty()) {
            LOGGER.info("finished handling import data");
        }
    }

    private static void handleExport(ClientConfig config, UUID clientCallId) {
        if (!config.getExp().isEmpty()) {
            LOGGER.info("Handling export data");
        }
        for (ApiVariantPair expConfig : config.getExp()) {
            LOGGER.info("export variant " + expConfig.getVariant() + " to " + expConfig.getApi());
            client.updateExport(expConfig.getApi(), clientCallId, expConfig.getVariant());
        }
        if (!config.getExp().isEmpty()) {
            LOGGER.info("finished handling export data");
        }
    }

    private static void handleDownloads(ClientConfig config, UUID clientCallId) {
        if (!config.getDownloads().isEmpty()) {
            LOGGER.info("Starting download");
        }
        for (DownloadApiTable downloadConfig : config.getDownloads()) {
            LOGGER.info("downloading from " + downloadConfig.getApi() + " to " + downloadConfig.getTable().getName());
            DbDownloader downloader = new DbDownloader(config, clientCallId, downloadConfig.getTable());
            if (downloadConfig.isTruncate()) {
                LOGGER.info("truncating before downloading");
                downloader.truncate();
            }
            new RestApiDownloader(config, clientCallId, downloader, downloadConfig.getApi()).downloadList(client);
        }
        if (!config.getDownloads().isEmpty()) {
            LOGGER.info("Download finished");
        }
    }

    private static List<UUID> handleExceptions() {
        ArrayList<UUID> successfullyLoggedExceptions = new ArrayList<UUID>();
        for (ChronappExceptionStore store : exceptionStoreList) {
            try {
                UUID successFullyLogged = ChronappInterfaceClient.logExceptions(store);
                successfullyLoggedExceptions.add(successFullyLogged);
            }
            catch (ChronappException e) {
                store.addException(e);
                LOGGER.error((Object)("Unable to handle Exception for job " + String.valueOf(store.getJobUuid())), e);
            }
        }
        return successfullyLoggedExceptions;
    }

    private static UUID logExceptions(ChronappExceptionStore store) {
        store.getExceptions().forEach((k, v) -> client.exceptions(v.getClientCallId(), v.getDescription(), v.getException().getMessage(), v.getLogId()));
        LOGGER.info("exceptions handled");
        return store.getJobUuid();
    }

    private static void writeExceptionToSystemFile() {
        try (FileOutputStream fileOut = new FileOutputStream("exceptionStoreList.ser");
             ObjectOutputStream out = new ObjectOutputStream(fileOut);){
            out.writeObject(exceptionStoreList);
        }
        catch (IOException ex) {
            LOGGER.error((Object)"Could not write exceptionStoreList to file", ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static LinkedList<ChronappExceptionStore> readExceptionsFromSystemFile() {
        try (FileInputStream fileImput = new FileInputStream("exceptionStoreList.ser");){
            LinkedList<ChronappExceptionStore> linkedList;
            try (ObjectInputStream in = new ObjectInputStream(fileImput);){
                LinkedList list = (LinkedList)in.readObject();
                linkedList = new LinkedList<ChronappExceptionStore>(list);
            }
            return linkedList;
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.debug((Object)"Could not read exceptionStoreList from file", e);
            return new LinkedList<ChronappExceptionStore>();
        }
    }

    private static void addExceptionToStore(ChronappException e) {
        ChronappExceptionStore exceptionStore = ChronappInterfaceClient.getChronappExceptionStore(e);
        if (!exceptionStore.getExceptions().containsKey(e.getCause().getClass().getName())) {
            exceptionStore.addException(e);
        }
    }

    private static ChronappExceptionStore getChronappExceptionStore(ChronappException e) {
        ChronappExceptionStore exceptionStore = exceptionStoreList.stream().filter(exStore -> exStore.getJobUuid().equals(e.getClientCallId())).findFirst().orElse(null);
        if (exceptionStore == null) {
            exceptionStore = new ChronappExceptionStore(e);
            exceptionStoreList.add(new ChronappExceptionStore(e));
        }
        return exceptionStore;
    }
}

