/*
 * Decompiled with CFR 0.152.
 */
package com.chronapp.porter.client.auth;

import com.chronapp.porter.client.auth.OIDCToken;
import com.chronapp.porter.config.SSO;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.time.LocalDateTime;

public class TokenExtractor
implements ClientRequestFilter {
    private static final long REFRESH_MIN_THRESHOLD_SECONDS = 30L;
    private final SSO config;
    private final String tenant;
    private String token;
    private LocalDateTime expires;

    public TokenExtractor(String tenant, SSO config) {
        this.config = config;
        this.tenant = tenant;
        this.fetchAccessToken();
    }

    public String getToken() {
        return this.token;
    }

    @Override
    public void filter(ClientRequestContext requestContext) {
        requestContext.getHeaders().putSingle("Authorization", "Bearer " + this.getToken());
    }

    private void fetchAccessToken() {
        block13: {
            Form form = new Form();
            form.param("grant_type", "client_credentials");
            form.param("client_id", this.config.getClient());
            form.param("client_secret", this.config.getSecret());
            try (Client client = ClientBuilder.newClient();
                 Response response = client.target(this.config.getUrl() + "/" + this.tenant + "/protocol/openid-connect/token").request().accept(MediaType.APPLICATION_JSON_TYPE).post(Entity.form(form));){
                if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                    OIDCToken oidctoken = response.readEntity(OIDCToken.class);
                    this.token = oidctoken.getAccessToken();
                    this.expires = LocalDateTime.now().plusSeconds((long)oidctoken.getExpiresIn() - 30L);
                    break block13;
                }
                throw new IllegalStateException("Failed to get accessToken!" + response.getStatus());
            }
        }
    }

    public void refreshTokenIfNeeded(boolean forceRefresh) {
        if (forceRefresh || this.expires.isBefore(LocalDateTime.now())) {
            this.fetchAccessToken();
        }
    }
}

