/*
 * Decompiled with CFR 0.152.
 */
package com.chronapp.porter.common;

import com.chronapp.porter.common.ChronappException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class ChronappExceptionStore
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int EXPIRATION_DAYS = 10;
    private final transient LocalDate date = LocalDate.now();
    private final UUID jobUuid;
    private Map<String, ChronappException> exceptions = new HashMap<String, ChronappException>();

    public ChronappExceptionStore(ChronappException exception) {
        this.exceptions.put(exception.getException().getMessage(), exception);
        this.jobUuid = exception.getClientCallId();
    }

    public void addException(ChronappException exception) {
        String key = Optional.ofNullable(exception.getException()).map(Throwable::getMessage).orElse("unknown");
        this.exceptions.computeIfAbsent(key, k -> exception);
    }

    public UUID getJobUuid() {
        return this.jobUuid;
    }

    public Map<String, ChronappException> getExceptions() {
        return Map.copyOf(this.exceptions);
    }

    public boolean isExpired() {
        return this.date.isBefore(LocalDate.now().minusDays(10L));
    }
}

