/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal.proxy.extractors;

import jakarta.ws.rs.core.Response;
import java.lang.reflect.Method;
import org.jboss.resteasy.annotations.ResponseObject;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.BodyEntityExtractor;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.ClientContext;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.EntityExtractor;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.EntityExtractorFactory;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.ResponseObjectEntityExtractorFactory;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.ResponseObjectProxy;

public class DefaultEntityExtractorFactory
implements EntityExtractorFactory {
    public static final EntityExtractor clientResponseExtractor = new EntityExtractor<ClientResponse>(){

        @Override
        public ClientResponse extractEntity(ClientContext context, Object ... args) {
            return context.getClientResponse();
        }
    };

    public static EntityExtractor<Response.Status> createStatusExtractor(final boolean release) {
        return new EntityExtractor<Response.Status>(){

            @Override
            public Response.Status extractEntity(ClientContext context, Object ... args) {
                if (release) {
                    context.getClientResponse().close();
                }
                return Response.Status.fromStatusCode(context.getClientResponse().getStatus());
            }
        };
    }

    public static final EntityExtractor createVoidExtractor() {
        return new EntityExtractor(){

            public Object extractEntity(ClientContext context, Object ... args) {
                ClientResponse response = context.getClientResponse();
                int status = response.getStatus();
                if (status >= 400) {
                    response.bufferEntity();
                    response.close();
                    ClientInvocation.handleErrorStatus(response);
                }
                response.close();
                return null;
            }
        };
    }

    @Override
    public EntityExtractor createExtractor(Method method) {
        Class<?> returnType = method.getReturnType();
        if (DefaultEntityExtractorFactory.isVoidReturnType(returnType)) {
            return DefaultEntityExtractorFactory.createVoidExtractor();
        }
        if (returnType.equals(Response.Status.class)) {
            return DefaultEntityExtractorFactory.createStatusExtractor(true);
        }
        if (Response.class.isAssignableFrom(returnType)) {
            return clientResponseExtractor;
        }
        if (returnType.isInterface() && returnType.isAnnotationPresent(ResponseObject.class)) {
            return new ResponseObjectProxy(method, new ResponseObjectEntityExtractorFactory());
        }
        return new BodyEntityExtractor(method);
    }

    protected EntityExtractor createResponseTypeEntityExtractor(Method method) {
        return new EntityExtractor<Response>(){

            @Override
            public Response extractEntity(ClientContext context, Object ... args) {
                return context.getClientResponse();
            }
        };
    }

    public static final boolean isVoidReturnType(Class<?> returnType) {
        return returnType == null || Void.TYPE.equals(returnType) || Void.class.equals(returnType);
    }
}

