/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.mock.MockHttpRequest;
import org.jboss.resteasy.mock.MockHttpResponse;
import org.jboss.resteasy.spi.Dispatcher;
import org.jboss.resteasy.spi.HttpRequest;

public class InternalDispatcher {
    private static InternalDispatcher instance = new InternalDispatcher();

    public static InternalDispatcher getInstance() {
        return instance;
    }

    public static void setInstance(InternalDispatcher instance) {
        InternalDispatcher.instance = instance;
    }

    public Object getEntity(String uri) {
        return this.getResponse(uri).getEntity();
    }

    public Response delete(String uri) {
        return this.getResponse(InternalDispatcher.createRequest(uri, "DELETE"));
    }

    public Response putEntity(String uri, String contentType, Object entity) {
        return this.executeEntity("PUT", uri, contentType, entity);
    }

    public Response putEntity(String uri, Object entity) {
        return this.putEntity(uri, "*/*", entity);
    }

    public Response executeEntity(String method, String uri, String contentType, Object entity) {
        MockHttpRequest post = InternalDispatcher.createRequest(uri, method);
        post.contentType(contentType);
        return this.getResponse(post, entity);
    }

    public Response postEntity(String uri, String contentType, Object entity) {
        return this.executeEntity("POST", uri, contentType, entity);
    }

    public Response postEntity(String uri, Object entity) {
        return this.postEntity(uri, "*/*", entity);
    }

    public Response getResponse(String uri) {
        return this.getResponse(InternalDispatcher.createRequest(uri, "GET"));
    }

    public Response getResponse(MockHttpRequest request) {
        return this.getResponse(request, null);
    }

    public Response getResponse(MockHttpRequest request, Object entity) {
        Dispatcher dispatcher = ResteasyContext.getContextData(Dispatcher.class);
        if (dispatcher == null) {
            return null;
        }
        this.enhanceRequest(request);
        return dispatcher.internalInvocation(request, new MockHttpResponse(), entity);
    }

    protected void enhanceRequest(MockHttpRequest request) {
        HttpRequest previousRequest = ResteasyContext.getContextData(HttpRequest.class);
        if (previousRequest != null) {
            request.getMutableHeaders().putAll(previousRequest.getHttpHeaders().getRequestHeaders());
        }
    }

    public static MockHttpRequest createRequest(String relativeUri, String verb) {
        UriInfo uriInfo = ResteasyContext.getContextData(UriInfo.class);
        URI baseUri = uriInfo.getBaseUri();
        URI absoluteUri = baseUri.resolve(InternalDispatcher.parseRelativeUri(relativeUri));
        return MockHttpRequest.create(verb, absoluteUri, baseUri);
    }

    private static URI parseRelativeUri(String relativeUri) {
        if (relativeUri.startsWith("/")) {
            return URI.create(relativeUri.substring(1));
        }
        return URI.create(relativeUri);
    }
}

