/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.core.CompletionStageHolder;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InternalServerErrorException;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.ValueInjector;
import org.jboss.resteasy.spi.metadata.FieldParameter;
import org.jboss.resteasy.spi.metadata.Parameter;
import org.jboss.resteasy.spi.metadata.ResourceClass;
import org.jboss.resteasy.spi.metadata.SetterParameter;

public class ResourcePropertyInjector
implements PropertyInjector {
    protected List<FieldInjector> fields = new ArrayList<FieldInjector>();
    protected List<SetterInjector> setters = new ArrayList<SetterInjector>();
    protected ResourceClass resourceClass;
    protected ResteasyProviderFactory factory;

    public ResourcePropertyInjector(ResourceClass resourceClass, ResteasyProviderFactory factory) {
        ValueInjector injector;
        this.resourceClass = resourceClass;
        this.factory = factory;
        for (FieldParameter fieldParameter : resourceClass.getFields()) {
            injector = factory.getInjectorFactory().createParameterExtractor(fieldParameter, factory);
            if (injector == null) continue;
            this.fields.add(new FieldInjector(fieldParameter, injector));
        }
        for (Parameter parameter : resourceClass.getSetters()) {
            injector = factory.getInjectorFactory().createParameterExtractor(parameter, factory);
            if (injector == null) continue;
            this.setters.add(new SetterInjector((SetterParameter)parameter, injector));
        }
    }

    @Override
    public CompletionStage<Void> inject(HttpRequest request, HttpResponse response, Object target, boolean unwrapAsync) throws Failure {
        Object injectedObject;
        CompletionStage<Object> ret = null;
        for (FieldInjector fieldInjector : this.fields) {
            injectedObject = fieldInjector.injector.inject(request, response, unwrapAsync);
            if (injectedObject != null && injectedObject instanceof CompletionStage) {
                if (ret == null) {
                    ret = CompletableFuture.completedFuture(null);
                }
                ret = ret.thenCompose(v -> ((CompletionStage)injectedObject).thenAccept(value -> {
                    try {
                        injector.param.getField().set(target, value);
                    }
                    catch (IllegalAccessException e) {
                        throw new InternalServerErrorException(e);
                    }
                }));
                continue;
            }
            try {
                fieldInjector.param.getField().set(target, CompletionStageHolder.resolve(injectedObject));
            }
            catch (IllegalAccessException e) {
                throw new InternalServerErrorException(e);
            }
        }
        for (SetterInjector setterInjector : this.setters) {
            injectedObject = setterInjector.injector.inject(request, response, unwrapAsync);
            if (injectedObject != null && injectedObject instanceof CompletionStage) {
                if (ret == null) {
                    ret = CompletableFuture.completedFuture(null);
                }
                ret = ret.thenCompose(v -> ((CompletionStage)injectedObject).thenAccept(value -> {
                    try {
                        injector.param.getSetter().invoke(target, value);
                    }
                    catch (IllegalAccessException e) {
                        throw new InternalServerErrorException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new ApplicationException(e.getCause());
                    }
                }));
                continue;
            }
            try {
                setterInjector.param.getSetter().invoke(target, CompletionStageHolder.resolve(injectedObject));
            }
            catch (IllegalAccessException e) {
                throw new InternalServerErrorException(e);
            }
            catch (InvocationTargetException e) {
                throw new ApplicationException(e.getCause());
            }
        }
        return ret;
    }

    @Override
    public CompletionStage<Void> inject(Object target, boolean unwrapAsync) {
        Object injectedObject;
        CompletionStage<Object> ret = null;
        for (FieldInjector fieldInjector : this.fields) {
            injectedObject = fieldInjector.injector.inject(unwrapAsync);
            if (injectedObject != null && injectedObject instanceof CompletionStage) {
                if (ret == null) {
                    ret = CompletableFuture.completedFuture(null);
                }
                ret = ret.thenCompose(v -> ((CompletionStage)injectedObject).thenAccept(value -> {
                    try {
                        injector.param.getField().set(target, value);
                    }
                    catch (IllegalAccessException e) {
                        throw new InternalServerErrorException(e);
                    }
                }));
                continue;
            }
            try {
                fieldInjector.param.getField().set(target, CompletionStageHolder.resolve(injectedObject));
            }
            catch (IllegalAccessException e) {
                throw new InternalServerErrorException(e);
            }
        }
        for (SetterInjector setterInjector : this.setters) {
            injectedObject = setterInjector.injector.inject(unwrapAsync);
            if (injectedObject != null && injectedObject instanceof CompletionStage) {
                if (ret == null) {
                    ret = CompletableFuture.completedFuture(null);
                }
                ret = ret.thenCompose(v -> ((CompletionStage)injectedObject).thenAccept(value -> {
                    try {
                        injector.param.getSetter().invoke(target, value);
                    }
                    catch (IllegalAccessException e) {
                        throw new InternalServerErrorException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw new ApplicationException(e.getCause());
                    }
                }));
                continue;
            }
            try {
                setterInjector.param.getSetter().invoke(target, CompletionStageHolder.resolve(injectedObject));
            }
            catch (IllegalAccessException e) {
                throw new InternalServerErrorException(e);
            }
            catch (InvocationTargetException e) {
                throw new ApplicationException(e.getCause());
            }
        }
        return ret;
    }

    private static class FieldInjector {
        public FieldParameter param;
        public ValueInjector injector;

        private FieldInjector(FieldParameter param, ValueInjector injector) {
            this.param = param;
            this.injector = injector;
        }
    }

    private static class SetterInjector {
        public SetterParameter param;
        public ValueInjector injector;

        private SetterInjector(SetterParameter param, ValueInjector injector) {
            this.param = param;
            this.injector = injector;
        }
    }
}

