/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.se;

import jakarta.ws.rs.SeBootstrap;
import jakarta.ws.rs.core.Application;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.Index;
import org.jboss.logging.Logger;
import org.jboss.resteasy.concurrent.ContextualExecutorService;
import org.jboss.resteasy.concurrent.ContextualExecutors;
import org.jboss.resteasy.core.AsynchronousDispatcher;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.scanner.ResourceScanner;
import org.jboss.resteasy.core.se.ConfigurationOption;
import org.jboss.resteasy.core.se.ResteasySeConfiguration;
import org.jboss.resteasy.plugins.server.embedded.EmbeddedServer;
import org.jboss.resteasy.plugins.server.embedded.EmbeddedServers;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyDeployment;

public class ResteasySeInstance
implements SeBootstrap.Instance {
    private static final Logger LOGGER = Logger.getLogger(ResteasySeInstance.class);
    private final EmbeddedServer server;
    private final SeBootstrap.Configuration configuration;
    private final ExecutorService executor;
    private final AtomicBoolean shutdownHookRegistered;
    private final List<Consumer<SeBootstrap.Instance.StopResult>> onShutdownCallbacks;
    private final SeBootstrap.Instance.StopResult stopResult;

    private ResteasySeInstance(final EmbeddedServer server, SeBootstrap.Configuration configuration, ExecutorService executor) {
        this.server = server;
        this.configuration = configuration;
        this.executor = executor;
        this.shutdownHookRegistered = new AtomicBoolean(false);
        this.onShutdownCallbacks = new CopyOnWriteArrayList<Consumer<SeBootstrap.Instance.StopResult>>();
        this.stopResult = new SeBootstrap.Instance.StopResult(){

            @Override
            public <T> T unwrap(Class<T> nativeClass) {
                if (nativeClass != null && nativeClass.isInstance(server)) {
                    return nativeClass.cast(server);
                }
                return null;
            }
        };
    }

    public static CompletionStage<SeBootstrap.Instance> create(Application application, SeBootstrap.Configuration configuration) {
        ContextualExecutorService executor = ContextualExecutors.threadPool();
        return CompletableFuture.supplyAsync(() -> {
            try {
                SeBootstrap.Configuration config = ResteasySeConfiguration.from(configuration);
                EmbeddedServer server = EmbeddedServers.findServer(config);
                ResteasyDeployment deployment = server.getDeployment();
                deployment.setRegisterBuiltin((Boolean)ConfigurationOption.REGISTER_BUILT_INS.getValue(config));
                deployment.setApplication(application);
                try {
                    ResteasySeInstance.scanForResources(deployment, application, config);
                }
                catch (IOException e) {
                    throw Messages.MESSAGES.failedToScanResources(e);
                }
                deployment.start();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debugf("Application %s used for %s", (Object)deployment.getApplication(), (Object)server);
                    deployment.getResourceClasses().forEach(name -> LOGGER.debugf("Resource %s found for %s", name, (Object)server));
                    deployment.getProviderClasses().forEach(name -> LOGGER.debugf("Provider %s found for %s", name, (Object)server));
                }
                server.start(config);
                return new ResteasySeInstance(server, config, executor);
            }
            catch (Throwable t) {
                throw new CompletionException(t);
            }
        }, executor);
    }

    public static CompletionStage<SeBootstrap.Instance> create(Class<? extends Application> applicationClass, SeBootstrap.Configuration configuration) {
        ContextualExecutorService executor = ContextualExecutors.threadPool();
        return CompletableFuture.supplyAsync(() -> {
            try {
                SeBootstrap.Configuration config = ResteasySeConfiguration.from(configuration);
                EmbeddedServer server = EmbeddedServers.findServer(config);
                ResteasyDeployment deployment = server.getDeployment();
                deployment.setRegisterBuiltin((Boolean)ConfigurationOption.REGISTER_BUILT_INS.getValue(config));
                deployment.setApplicationClass(applicationClass.getName());
                deployment.start();
                Application application = deployment.getApplication();
                try {
                    ResteasySeInstance.scanForResources(deployment, application, config);
                    deployment.registration();
                }
                catch (IOException e) {
                    throw Messages.MESSAGES.failedToScanResources(e);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debugf("Application %s used for %s", (Object)deployment.getApplication(), (Object)server);
                    deployment.getResourceClasses().forEach(name -> LOGGER.debugf("Resource %s found for %s", name, (Object)server));
                    deployment.getProviderClasses().forEach(name -> LOGGER.debugf("Provider %s found for %s", name, (Object)server));
                }
                server.start(config);
                return new ResteasySeInstance(server, config, executor);
            }
            catch (Throwable t) {
                throw new CompletionException(t);
            }
        }, executor);
    }

    @Override
    public SeBootstrap.Configuration configuration() {
        return this.configuration;
    }

    @Override
    public CompletionStage<SeBootstrap.Instance.StopResult> stop() {
        Map<Class<?>, Object> currentContext = ResteasyContext.getContextDataMap(false);
        ResteasyContext.clearContextData();
        CompletableFuture cf = new CompletableFuture();
        this.executor.submit(() -> {
            try {
                ResteasyContext.pushContextDataMap(currentContext);
                try {
                    this.server.stop();
                    cf.complete(this.stopResult);
                }
                finally {
                    ResteasyContext.clearContextData();
                }
            }
            catch (Throwable t) {
                cf.completeExceptionally(t);
            }
        });
        return cf.whenComplete((stopResult, throwable) -> this.executor.shutdownNow());
    }

    @Override
    public <T> T unwrap(Class<T> nativeClass) {
        if (nativeClass != null && nativeClass.isInstance(this.server)) {
            return nativeClass.cast(this.server);
        }
        return null;
    }

    @Override
    public void stopOnShutdown(Consumer<SeBootstrap.Instance.StopResult> consumer) {
        this.onShutdownCallbacks.add(consumer);
        if (this.shutdownHookRegistered.compareAndSet(false, true)) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    this.server.stop();
                }
                catch (Throwable t) {
                    LogMessages.LOGGER.failedStopOnShutdown(t);
                }
                for (Consumer<SeBootstrap.Instance.StopResult> callback : this.onShutdownCallbacks) {
                    try {
                        callback.accept(this.stopResult);
                    }
                    catch (Throwable t) {
                        LogMessages.LOGGER.failedToExecuteCallback(t, callback);
                    }
                }
            }, "resteasy-se-shutdown-hook"));
        }
    }

    private static void scanForResources(ResteasyDeployment deployment, Application application, SeBootstrap.Configuration configuration) throws IOException {
        if (application.getClasses() != null && !application.getClasses().isEmpty() || application.getSingletons() != null && !application.getSingletons().isEmpty()) {
            return;
        }
        Index index = (Index)ConfigurationOption.JANDEX_INDEX.getValue(configuration);
        ResourceScanner resourceScanner = index == null ? ResourceScanner.fromClassPath(ResteasySeInstance.resolveClassLoader(application.getClass()), (Predicate)ConfigurationOption.JANDEX_CLASS_PATH_FILTER.getValue(configuration)) : ResourceScanner.of(index);
        if (ResteasySeInstance.loadServices(application.getProperties())) {
            Set resources = resourceScanner.getResources().stream().filter(name -> !AsynchronousDispatcher.class.getName().equals(name)).collect(Collectors.toSet());
            deployment.getScannedResourceClasses().addAll(resources);
            deployment.getScannedProviderClasses().addAll(resourceScanner.getProviders());
        }
    }

    private static boolean loadServices(Map<String, Object> props) {
        Object value = props.get("jakarta.ws.rs.loadServices");
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return true;
    }

    static ClassLoader resolveClassLoader(Class<?> c) {
        if (c == null) {
            return ResteasySeInstance.currentClassLoader();
        }
        return c.getClassLoader();
    }

    private static ClassLoader currentClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ResteasySeInstance.class.getClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }
}

