/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jackson;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.fasterxml.jackson.jakarta.rs.base.util.ClassKey;
import com.fasterxml.jackson.jakarta.rs.cfg.ObjectWriterInjector;
import com.fasterxml.jackson.jakarta.rs.cfg.ObjectWriterModifier;
import com.fasterxml.jackson.jakarta.rs.json.JacksonJsonProvider;
import com.fasterxml.jackson.jakarta.rs.json.JsonEndpointConfig;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.resteasy.annotations.providers.jackson.Formatted;
import org.jboss.resteasy.core.interception.jaxrs.DecoratorMatcher;
import org.jboss.resteasy.core.messagebody.AsyncBufferedMessageBodyWriter;
import org.jboss.resteasy.plugins.providers.jackson.DecoratedEntityContainer;
import org.jboss.resteasy.plugins.providers.jackson.JacksonOptions;
import org.jboss.resteasy.plugins.providers.jackson.ResteasyObjectWriterInjector;
import org.jboss.resteasy.plugins.providers.jackson.WhiteListPolymorphicTypeValidatorBuilder;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.util.DelegatingOutputStream;

@Provider
@Consumes(value={"application/json", "application/*+json", "text/json"})
@Produces(value={"application/json", "application/*+json", "text/json"})
public class ResteasyJackson2Provider
extends JacksonJsonProvider
implements AsyncBufferedMessageBodyWriter<Object> {
    DecoratorMatcher decoratorMatcher = new DecoratorMatcher();
    protected final ConcurrentHashMap<ClassAnnotationKey, JsonEndpointConfig> _readers = new ConcurrentHashMap();
    protected final ConcurrentHashMap<ClassAnnotationKey, Boolean> decorators = new ConcurrentHashMap();
    protected final ConcurrentHashMap<ClassAnnotationKey, JsonEndpointConfig> _writers = new ConcurrentHashMap();

    @Override
    public boolean isReadable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return super.isReadable(aClass, type, annotations, mediaType);
    }

    @Override
    public boolean isWriteable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return super.isWriteable(aClass, type, annotations, mediaType);
    }

    @Override
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : readFrom", (Object)this.getClass().getName());
        ClassAnnotationKey key = new ClassAnnotationKey(type, annotations);
        JsonEndpointConfig endpoint = this._readers.get(key);
        if (endpoint == null) {
            Object mapper = this.locateMapper(type, mediaType);
            PolymorphicTypeValidator ptv = ((ObjectMapper)mapper).getPolymorphicTypeValidator();
            if (ptv == null || ptv instanceof LaissezFaireSubTypeValidator) {
                ((ObjectMapper)mapper).setPolymorphicTypeValidator(new WhiteListPolymorphicTypeValidatorBuilder().build());
            }
            endpoint = (JsonEndpointConfig)this._configForReading(mapper, annotations, null);
            this._readers.put(key, endpoint);
        }
        ObjectReader reader = endpoint.getReader();
        try (JsonParser jp = this._createParser(reader, entityStream);){
            if (jp == null) {
                Object var11_11 = null;
                return var11_11;
            }
            if (jp.nextToken() == null) {
                Object var11_12 = null;
                return var11_12;
            }
            if (type == JsonParser.class) {
                JsonParser jsonParser = jp;
                return jsonParser;
            }
            Object t = reader.forType(reader.getTypeFactory().constructType(genericType)).readValue(jp);
            return t;
        }
    }

    @Override
    public void writeTo(Object value, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : writeTo", (Object)this.getClass().getName());
        entityStream = new DelegatingOutputStream(entityStream){

            @Override
            public void flush() throws IOException {
            }
        };
        ClassAnnotationKey key = new ClassAnnotationKey(type, annotations);
        JsonEndpointConfig endpoint = this._writers.get(key);
        if (endpoint == null) {
            Object mapper = this.locateMapper(type, mediaType);
            PolymorphicTypeValidator ptv = ((ObjectMapper)mapper).getPolymorphicTypeValidator();
            if (ptv == null || ptv instanceof LaissezFaireSubTypeValidator) {
                ((ObjectMapper)mapper).setPolymorphicTypeValidator(new WhiteListPolymorphicTypeValidatorBuilder().build());
            }
            endpoint = (JsonEndpointConfig)this._configForWriting(mapper, annotations, null);
            this._writers.put(key, endpoint);
        }
        ObjectWriter writer = endpoint.getWriter();
        boolean withIndentOutput = false;
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (!annotation.annotationType().equals(Formatted.class)) continue;
                withIndentOutput = true;
                break;
            }
        }
        JsonEncoding enc = this.findEncoding(mediaType, httpHeaders);
        try (JsonGenerator jg = writer.getFactory().createGenerator(entityStream, enc);){
            Boolean hasDecorator;
            jg.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
            if (writer.isEnabled(SerializationFeature.INDENT_OUTPUT) || withIndentOutput) {
                jg.useDefaultPrettyPrinter();
            }
            JavaType rootType = null;
            if (genericType != null && value != null && genericType.getClass() != Class.class && (rootType = writer.getTypeFactory().constructType(genericType)).getRawClass() == Object.class) {
                rootType = null;
            }
            if (rootType != null) {
                writer = writer.forType(rootType);
            }
            value = endpoint.modifyBeforeWrite(value);
            ObjectWriterModifier mod = ObjectWriterInjector.getAndClear();
            if (mod == null) {
                ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                mod = ResteasyObjectWriterInjector.get(tccl);
            }
            if (mod != null) {
                writer = mod.modify(endpoint, httpHeaders, value, writer, jg);
            }
            if ((hasDecorator = this.decorators.get(key)) == null) {
                if (this.decoratorMatcher.hasDecorator(DecoratedEntityContainer.class, annotations)) {
                    this.decoratorMatcher.decorate(DecoratedEntityContainer.class, new DecoratedEntityContainer(value), type, annotations, mediaType);
                    this.decorators.put(key, Boolean.TRUE);
                } else {
                    this.decorators.put(key, Boolean.FALSE);
                }
            } else if (hasDecorator.booleanValue()) {
                this.decoratorMatcher.decorate(DecoratedEntityContainer.class, new DecoratedEntityContainer(value), type, annotations, mediaType);
            }
            writer.writeValue(jg, value);
        }
    }

    @Override
    protected ObjectMapper _locateMapperViaProvider(Class<?> type, MediaType mediaType) {
        ObjectMapper mapper = super._locateMapperViaProvider(type, mediaType);
        if (mapper == null && ResteasyJackson2Provider.useDefaultObjectMapper()) {
            return new ObjectMapper().findAndRegisterModules();
        }
        return mapper;
    }

    private static boolean useDefaultObjectMapper() {
        return (Boolean)JacksonOptions.DISABLE_DEFAULT_OBJECT_MAPPER.getValue() == false;
    }

    private static class ClassAnnotationKey {
        private AnnotationArrayKey annotations;
        private ClassKey classKey;
        private int hash;

        private ClassAnnotationKey(Class<?> clazz, Annotation[] annotations) {
            this.annotations = new AnnotationArrayKey(annotations);
            this.classKey = new ClassKey(clazz);
            this.hash = this.annotations.hashCode();
            this.hash = 31 * this.hash + this.classKey.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassAnnotationKey that = (ClassAnnotationKey)o;
            if (!this.annotations.equals(that.annotations)) {
                return false;
            }
            return this.classKey.equals(that.classKey);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static class AnnotationArrayKey {
        private static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
        private final Annotation[] annotations;
        private final int hash;

        private AnnotationArrayKey(Annotation[] annotations) {
            this.annotations = annotations == null || annotations.length == 0 ? NO_ANNOTATIONS : annotations;
            this.hash = AnnotationArrayKey.calcHash(this.annotations);
        }

        private static int calcHash(Annotation[] annotations) {
            int result = annotations.length;
            result = 31 * result + Arrays.hashCode(annotations);
            return result;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            AnnotationArrayKey that = (AnnotationArrayKey)object;
            return this.hash == that.hash && Arrays.equals(this.annotations, that.annotations);
        }
    }
}

